/**
 * VINSpot Background Service Worker
 * by ICB Tech Solutions
 */

// Handle extension icon click - manual page scan
chrome.action.onClicked.addListener((tab) => {
    // Send message to content script to perform immediate scan
    chrome.tabs.sendMessage(tab.id, { action: 'scan' }, (response) => {
        if (chrome.runtime.lastError) {
            console.log('VINSpot: Could not connect to content script on this page');
        } else if (response) {
            console.log('VINSpot: Manual scan found', response.count, 'VINs');
        }
    });
});

// Handle messages from content script
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
    if (request.action === 'openIME') {
        // Open IME in a new window
        const url = request.url;
        chrome.windows.create({
            url: url,
            type: 'popup',
            width: 1400,
            height: 900
        });
        sendResponse({ success: true });
    }
    return true;
});

// Log installation
chrome.runtime.onInstalled.addListener((details) => {
    if (details.reason === 'install') {
        console.log('VINSpot installed successfully!');
        // Could open a welcome page here
        // chrome.tabs.create({ url: 'https://marketeval.icbtechsolutions.com/vinspot/welcome' });
    } else if (details.reason === 'update') {
        console.log('VINSpot updated to version', chrome.runtime.getManifest().version);
    }
});
