# VINSpot Chrome Extension

**Spot VINs on auction sites and instantly evaluate them with IME**

by ICB Tech Solutions

---

## 🎯 What is VINSpot?

VINSpot is a Chrome browser extension that automatically detects Vehicle Identification Numbers (VINs) on auction websites and places a small icon next to each one. Click the icon to instantly open IME (Instant Market Eval) with the VIN and mileage pre-populated, ready for evaluation.

## ✨ Features

- **Automatic VIN Detection** - Scans pages for 17-character VINs
- **Mileage Association** - Automatically finds the mileage near each VIN
- **One-Click Evaluation** - Opens IME with pre-filled data
- **Non-Intrusive** - Small icon that doesn't disrupt the page layout
- **Works on Multiple Sites** - Manheim, ADESA, Metro Auto Auction, DAX, and more
- **Dynamic Content Support** - Detects VINs on simulcast and dynamically loaded content

## 📦 Installation

### Step 1: Generate Icons

1. Open `icons/generate-icons.html` in Chrome
2. Click each "Download" button to save the PNG files
3. Save them to the `icons/` folder with these exact names:
   - `icon16.png`
   - `icon32.png`
   - `icon48.png`
   - `icon128.png`

### Step 2: Load Extension in Chrome

1. Open Chrome and go to `chrome://extensions/`
2. Enable **Developer mode** (toggle in top right)
3. Click **Load unpacked**
4. Select the `vinspot` folder
5. The VINSpot extension should now appear in your extensions!

### Step 3: Pin the Extension (Optional)

1. Click the puzzle piece icon in Chrome toolbar
2. Find VINSpot and click the pin icon
3. The VINSpot icon will now always be visible

## 🚀 Usage

1. **Navigate to an auction site** (Manheim, ADESA, Metro Auto Auction, etc.)
2. **VINSpot automatically scans** the page for VINs
3. **Look for the green crosshair icon** next to each detected VIN
4. **Click the icon** to open the IME tool
5. **First time:** Log in with your credentials (one-time authentication)
6. **After login:** IME opens with VIN and mileage pre-populated
7. **Subsequent clicks:** You'll go directly to IME (no login required)

## 🎨 Icon Legend

| Icon | Meaning |
|------|---------|
| 🟢 Green crosshair | VIN detected, mileage found - ready to evaluate |
| Hover effect | Pulsing ring indicates clickable |

## 🔧 Troubleshooting

### VINSpot icon not appearing?

- Make sure the extension is enabled in `chrome://extensions/`
- Refresh the page
- Some VINs may not be detected if they're in images or non-standard formats

### Mileage not detected?

- VINSpot looks for patterns like "Odo: 12345", "45,000mi", "Mileage: 12345"
- If mileage isn't found, you can manually enter it in IME

### Extension not working on a specific site?

- The site may need to be added to the permissions
- Contact ICB Tech Solutions for support

## 📋 Supported Sites

- Manheim (manheim.com)
- ADESA / Openlane (adesa.com, openlane.com)
- Metro Auto Auction (metroautoauction.com)
- DAX / Rockwall Auto Auction
- Edge Pipeline
- America's Auto Auction
- Most Simulcast platforms
- And many more...

## 🔒 Privacy

VINSpot:
- Does NOT collect or transmit any data
- Does NOT track your browsing
- Only activates when you click the icon
- All processing happens locally in your browser

## 📞 Support

For questions, issues, or feature requests:
- Website: https://imedealer.com
- Email: support@icbtechsolutions.com

---

**Version:** 1.1.2  
**© 2024 ICB Tech Solutions. All rights reserved.**
